package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.admin.dto.RoleDTO;
import gov.va.med.mhv.admin.model.Role;

@Component
public class RoleConverter {

	public static RoleDTO convert(Role role) {
		RoleDTO roleDTO = new RoleDTO();
		roleDTO.setName(role.getName());
		roleDTO.setOplock(role.getOplock());
		roleDTO.setRoleId(role.getId());
		roleDTO.setSecurityAdmin(role.getSecurityAdmin());
		return roleDTO;
	}

	public static Role convert(RoleDTO role) {
		Role roleDTO = new Role();
		roleDTO.setName(role.getName());
		roleDTO.setOplock(role.getOplock());
		roleDTO.setId(role.getRoleId());
		roleDTO.setSecurityAdmin(role.getSecurityAdmin());
		return roleDTO;
	}

	public List<RoleDTO> convert(List<Role> source) {

		List<RoleDTO> destination = new ArrayList<RoleDTO>();
		for (Role a : source) {
			destination.add(convert(a));
		}
		return destination;
	}

}
